# Software-Defined Networking (SDN) Concepts

## Introduction and Background

- SDN originated in academia about 15 years ago to advance IP packet forwarding.
- Early SDN vision:
    - Replace traditional routing protocols.
    - Deploy networks in software using hypervisors and programmatic interfaces.
- SDN addresses the need to automate, scale, and optimize networking for application agility.

## SDN Definition

- **SDN is:**
    
    - An architecture where control and data (forwarding) planes are decoupled.
    - Centralized intelligence and state.
    - Network virtualization via abstraction from applications.
    - Programmatic interfaces to influence provisioning and operations.
- **Characteristics:**
    
    - Dynamic, manageable, cost-effective, adaptable.
    - Enables programmability, automation, and external control (controllers, APIs).
    - Challenges traditional network engineering and promotes automation.
- **SDN is NOT:**
    
    - A simple “easy button.”
    - The ultimate solution for all networking problems.
    - A narrowly defined or engineer-replacing solution.
    - A requirement for all engineers to become programmers.

---

# Traditional vs. Software-Defined Networks

## Traditional Networks

- Each device has both control and data planes.
    - Devices make their own forwarding decisions.
    - Data plane is often hardware-based (ASICs) and handles packet forwarding.
- Still the dominant model today.

## Classic SDN Model

- Control plane is centralized in an SDN controller.
- Network devices (“dumb”) rely on the controller for instructions.
- Benefits:
    - Centralized management and evolution of control protocols.
- Challenges:
    - Scalability, availability, and performance of the controller in large networks.

## Hybrid SDN

- Combines traditional and SDN models.
- Uses both local intelligence and centralized controllers.
- Enables selective migration of features and applications to centralized control.
- Offers single-pane management via APIs while retaining proven protocols (e.g., BGP).

## Operational Shifts

- Move from manual (CLI/GUI) device management to automation and programmatic interfaces (XML, JSON).
- Objective: More efficient, less error-prone, and scalable network management.

## SDN Benefits Overview

- Fast, automated application deployment.
- On-demand application delivery and mobility at scale.
- Greater resource flexibility and utilization.
- Reduced IT costs, enhanced virtualization benefits.

---

# SDN Building Blocks

## Core Components

- **SDN Controller:** Central “brain,” replaces/enhances traditional device control functions.
- **Northbound APIs:** Interface between controller and applications/services (often REST-based).
- **Southbound APIs:** Interface between controller and network devices (e.g., OpenFlow).
- Support for virtual and physical network elements.

---

# Industry Trends

## Key Trends

- **Open-source Software:** Community-driven development, increased flexibility, lower costs.
- **Programmable Infrastructure:** Decreases human-to-machine interaction, aligns with DevOps.
- **Software-defined Networking:** Open interfaces, disaggregated control/data planes, virtualization, policy-centric networking.
- **DevOps:** Enhances speed and agility in deployment, promotes automation tools.
- **Application Centric Infrastructure (ACI):** Policy-based, application-focused networking.

---

# Open-Source Software

## Goals and Concepts

- Foster community involvement, open standards, and continuous improvement.
- Promote open APIs and protocol standards.

## Notable Projects

- **OpenFlow:** Protocol to manipulate switch forwarding tables.
- **Open vSwitch (OvS):** Virtual switch for hypervisors.
- **Contiv:** Policy for container-based apps.
- **OpenStack Neutron:** Network-as-a-service for cloud.
- **OpenDaylight:** Community-driven SDN project.
- **FD.io:** Libraries for flexible, programmable packet processing (includes Cisco’s VPP).

## Closed Model Contrast

- No access to underlying NOS, no open APIs, or community-driven improvement.

---

# Programmable Infrastructure

## Types of Network Programmability

- **On-box:** Scripting on the device (e.g., TcL, EEM, Python).
- **Off-box:** External scripting via controllers/servers using APIs (e.g., REST, NETCONF, RESTCONF).

## Examples

- **On-box:** TcL, EEM, POAP, Smart Install, Smart Port Macros, Python.
- **Off-box:** REST APIs, NETCONF, RESTCONF, SDKs, DevOps tools, Linux-based approaches.

---

# SDN as an Industry Trend

## Principles

- **Control/Data Plane Separation:** Focus on business benefits, not just protocol.
- **Software-only Network Virtualization:** Overlay tunnels for agility.
- **Network Functions Virtualization (NFV):** Virtual appliances (firewalls, routers, etc.).
- **Disaggregation:** Bare metal switching platforms with Linux NOS.
- **Device APIs:** Cisco devices support NETCONF, RESTCONF, gRPC, NX-API, REST.
- **Policy/ACI:** Policy-based networking for application delivery.

---

# DevOps

## Goals

- Increase deployment frequency.
- Faster time-to-market.
- Lower failure rate of releases.

## CALMS Framework

- **Culture:** Trust, respect, collaboration, shared goals, support, no blame.
- **Automation, Lean, Measurement, Sharing:** Key principles for DevOps integration.

## Common Tools

- **Operating Systems:** Linux (Debian, Red Hat, Ubuntu), etc.
- **Programming Languages:** Python, Go, Ruby.
- **Configuration Management:** SaltStack, Ansible, Chef, Puppet.
- **CI/CD:** CircleCI, Buildbot, Travis CI, Jenkins.
- **Version Control:** Git, GitHub, Bitbucket.

---

# Cisco SDN Solutions

## Overview

- Design, provision, and manage secure, automated networks.
- Enabler for intent-based networking (policy and intent-driven).

## Solutions Portfolio

- **Cisco Network Services Orchestrator (NSO):** Automates and orchestrates network services, manages traditional and virtual networks, leverages YANG for modeling.
- **Cisco Application Centric Infrastructure (ACI):** Data center automation, open ecosystem, managed via APIC.
- **Cisco Software-Defined Access (SD-Access):** Intent-based enterprise segmentation, automated policy, managed via Cisco Catalyst Center.
- **Cisco Catalyst SD-WAN:** Cloud-delivered WAN architecture, secure connectivity, managed via Cisco Catalyst SD-WAN Manager.
- **Cisco SD-Branch:** Integrates multiple functions as VNFs (routing, firewall, WLAN controller), managed via Catalyst Center.

---

# Cisco SDN Use Case Example

## Generic Branch-Campus Environment

- **Branch:** Cisco SD-Access managed by Catalyst Center; includes wireless, switching, and security VNFs.
- **WAN:** Cisco Catalyst SD-WAN connects branch to data center via MPLS/Internet.
- **Data Center:** Cisco ACI managed by APIC; provides automation and policy-driven architecture.
- **Orchestration:** Cisco NSO provides end-to-end orchestration and lifecycle management.
- **Interfaces:** Management via NETCONF (YANG), REST, RESTCONF; proprietary channels for specific functions.

---

# Additional Notes

- Not all technologies (APIC, NX-API) can be used simultaneously on the same device.
- Exception interfaces: CLI, SNMP for legacy devices, OpFlex (ACI), and proprietary firewall management.
- Example topologies illustrate possible, not mandatory, deployments.

---

## Example Applications of SDN

- Automated deployment of network services using Cisco NSO.
- Unified management and policy enforcement in branch and data center environments.
- Rapid provisioning and scaling of WAN and branch services via SD-WAN and SD-Branch.